//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: When the timer starts and the counter value is the same as TA0DRA, the TCA0 interrupt occurs.
//				  At this point, P90 output level is inverted. 
//****************************************** 
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6811.h"
void main()
{	
	WDCDR.byte= 0x4e;	//clear WDT
    /**********   
     setting TCA timer   
	   
	**********/

	P9CR.bit.b0 = 1;	//set P90 output
	__asm("DI");
	POFFCR0.byte = 0x1;
	EIRH.bit.b6 = 1;
	__asm("EI");
	TA0CR.byte = 0xC2; //enable overflow interrupt,TFF=1,no noise canceller,enable auto capture
	TA0MOD.byte = 0x80; //double buffer,source clk=fcgck/2^10,Timer mode
	TA0DRAL.byte = 0x1;
	TA0DRAH.byte = 0x2;  //counting register = 0x0201
	TA0CR.bit.b0 = 1;	//start Timer Counter
	while(1)
	{
		WDCDR.byte= 0x4e;	//clear WDT
	}            
       
    
}